% Histogram figure settings
function histogramData = histogramSettings(data,cent, twoTerm)
close all
figure()
hold on
[n, xout]=hist(data(:),cent);

f1=fit(cent',n','gauss1'); % Single peak Gaussian
rmse1 = sqrt(sum((n' - f1(cent)).^2)/numel(n)); % Root mean squared error

if ~twoTerm
    rmse1 = -1;
    rmse2 = 1;
else
    f2=fit(cent',n','gauss2'); % Two-term Gaussian
    rmse2 = sqrt(sum((n' - f2(cent)).^2)/numel(n)); % Root mean squared error
end

if rmse1 <= rmse2 % choose 1 or 2 term Gaussian based on the rmse
    betterFit = f1;
    coeffs = [f1.a1; f1.b1; f1.c1];
else
    betterFit = f2;
    coeffs = [f2.a1; f2.a2; f2.b1; f2.b2; f2.c1; f2.c2];
end    

plot(betterFit,cent',n', 'k.');
histogramData{1,1} = 'Frequency and bins';
histogramData{2,1} = 'Fit';
histogramData{1,2} = [n, xout];
histogramData{2,2} = coeffs;
hold on
set(gcf,'color','w');
set(gca,'FontSize',17);
hLeg = legend();
set(hLeg,'visible','off')
end